package walle

import (
	"fmt"
	"time"

	"a.yandex-team.ru/infra/rtc/instance_resolver/pkg/freshcache"
)

type CacheDriver struct {
	client *WalleClient
}

func (c *CacheDriver) Stop() {
	c.client.cancel()
}

func (c *CacheDriver) GetCache() interface{} {
	return c.client
}

func (c *CacheDriver) Update() error {
	_, err := c.client.updateHostMap()
	return err
}

func (c *CacheDriver) LoadState(path string) error {
	walleHostMap, err := c.client.loadHostMap(path)
	if err != nil {
		return err
	}
	c.client.hostMap = walleHostMap
	return nil
}

func (c *CacheDriver) DumpState(path string) error {
	if c.client.hostMap == nil {
		return fmt.Errorf("walle cache not initialized")
	}
	return c.client.dumpHostMap(c.client.hostMap, path)
}

func (c *CacheDriver) GetAge() time.Duration {
	if c.client.hostMap == nil {
		return time.Duration(0)
	}
	return time.Since(c.client.hostMap.Timestamp)
}

func (c *CacheDriver) GetOptions() freshcache.CacheDriverOptions {
	return freshcache.CacheDriverOptions{
		Name:        "walle",
		RefreshTime: 5 * time.Minute,
	}
}

func NewCacheDriver(client *WalleClient) *CacheDriver {
	return &CacheDriver{client: client}
}
