package freshcache

import (
	"time"
)

type CacheDriverOptions struct {
	Name        string
	RefreshTime time.Duration
}

type CacheDriver interface {
	Update() error
	LoadState(path string) error
	DumpState(path string) error
	GetAge() time.Duration
	GetOptions() CacheDriverOptions
	GetCache() interface{}
	Stop()
}

func DriverCacheExpired(driver CacheDriver) bool {
	now := time.Now()
	age := driver.GetAge()
	return now.Add(driver.GetOptions().RefreshTime).Before(now.Add(age))
}
