package log

import (
	"a.yandex-team.ru/library/go/core/log/zap"
	zp "go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

var (
	Level  = zp.NewAtomicLevelAt(zapcore.DebugLevel)
	Logger = zap.Must(zp.Config{
		Level:            Level,
		Encoding:         "console",
		OutputPaths:      []string{"stdout"},
		ErrorOutputPaths: []string{"stderr"},
		EncoderConfig: zapcore.EncoderConfig{
			MessageKey:     "msg",
			LevelKey:       "level",
			TimeKey:        "ts",
			CallerKey:      "caller",
			EncodeLevel:    zapcore.CapitalLevelEncoder,
			EncodeTime:     zapcore.ISO8601TimeEncoder,
			EncodeDuration: zapcore.StringDurationEncoder,
			EncodeCaller:   zapcore.ShortCallerEncoder,
		},
	})
)
