package util

type StringIntern struct {
	Cache map[string]*string
}

func NewStringIntern() *StringIntern {
	return &StringIntern{
		Cache: make(map[string]*string),
	}
}

func (c *StringIntern) Intern(needle string) *string {
	if cachedPtr, ok := c.Cache[needle]; ok {
		return cachedPtr
	} else {
		c.Cache[needle] = &needle
		return &needle
	}
}
