package util

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestStringIntern(t *testing.T) {
	storage := NewStringIntern()
	ptrA := storage.Intern("long string")
	ptrB := storage.Intern("long string")
	ptrC := storage.Intern("another string")
	assert.Equal(t, ptrA, ptrB)
	assert.Equal(t, *ptrA, *ptrB)
	assert.NotEqual(t, ptrB, ptrC)
	assert.NotEqual(t, *ptrB, *ptrC)
}
