package util

type SimpleSemaphore struct {
	channel chan int
}

func NewSimpleSemaphore(threads int) (semaphore *SimpleSemaphore) {
	semaphore = &SimpleSemaphore{
		channel: make(chan int, threads),
	}
	return
}

func (semaphore *SimpleSemaphore) Acquire() {
	semaphore.channel <- 1
}

func (semaphore *SimpleSemaphore) Release() {
	<-semaphore.channel
}
