package util

func SplitHosts(hosts []string, threads int) [][]string {
	lim, remainder := len(hosts)/threads, len(hosts)%threads
	if remainder > 0 || lim == 0 {
		lim++
	}
	var chunk []string
	chunks := make([][]string, 0, threads)
	for len(hosts) >= lim {
		chunk, hosts = hosts[:lim], hosts[lim:]
		chunks = append(chunks, chunk)
	}
	if len(hosts) > 0 {
		chunks = append(chunks, hosts)
	}
	return chunks
}
