package util

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSplitHosts(t *testing.T) {
	assert.Equal(t, SplitHosts([]string{}, 1), [][]string{})
	assert.Equal(t, SplitHosts([]string{"a"}, 1), [][]string{[]string{"a"}})
	assert.Equal(t, SplitHosts([]string{"a", "b"}, 1), [][]string{[]string{"a", "b"}})
	assert.Equal(t, SplitHosts([]string{"a", "b"}, 2), [][]string{[]string{"a"}, []string{"b"}})
	assert.Equal(t, SplitHosts([]string{"a", "b", "c"}, 2), [][]string{[]string{"a", "b"}, []string{"c"}})
}
