#pragma once

#include <infra/rtc/instance_resolver/api/yp_proxy.pb.h>
#include <infra/rtc/instance_resolver/api/yp_proxy.grpc.pb.h>
#include <yp/cpp/yp/client.h>

struct TYpProxyOptions {
    TString Address;
    TString Token;
};

class TYpProxyImpl final : public api::TYpProxy::Service {
public:
    TYpProxyImpl(const TYpProxyOptions& options);

    grpc::Status FindPodsetsByNode(
            grpc::ServerContext* context,
            const api::TFindPodsetsByNodeRequest* request,
            api::TFindPodsetsByNodeReply* response) override;
    grpc::Status GetNode(
            grpc::ServerContext* context,
            const api::TGetNodeRequest* request,
            api::TGetNodeReply* response) override;

private:
    using TYpClientMap = THashMap<TString, NYP::NClient::TClientPtr>;

    NYP::NClient::TClientPtr GetYpClient(const TString& origin);
    void RemoveYpClient(const TString& origin);

    TString Token;
    TYpClientMap YpClients;
    TAdaptiveLock Mutex;
};
