

import requests
import time

import infra.rtc.iolimit_ticketer.utils as utils
import pickle


AWACS_SERVICEC_CACHE_TTL = 24 * 60 * 60
AWACS_CACHE_VERSION = 1


class AwacsNannyServices:

    def __init__(self):

        self.awacs_projects = set()
        self._timestamp = time.time()
        self._version = AWACS_CACHE_VERSION

    def collect_awacs_balancers(self):
        headers = {"Authorization": "OAuth {0}".format(utils.get_nanny_oauth_token())}
        data = requests.get("https://nanny.yandex-team.ru/v2/services/?type=AWACS_BALANCER&exclude_runtime_attrs=1",
                            headers=headers).json()["result"]

        for record in data:
            self.awacs_projects.add(record["_id"])

    def check_actual(self):
        if time.time() - self._timestamp > AWACS_SERVICEC_CACHE_TTL:
            raise Exception("cache expired")
        if self._version != AWACS_CACHE_VERSION:
            raise Exception("version mismatch")


def get_awacs_services():
    services = AwacsNannyServices()
    services.collect_awacs_balancers()
    return services


def get_awacs_services_cached():
    """
    :rtype: AwacsNannyServices
    """
    file_name = "awacs_services.tmp"
    try:
        with open(file_name, "rb") as stream:
            result = pickle.load(stream)  # type: AwacsNannyServices
            result.check_actual()
            return result
    except Exception:
        result = get_awacs_services()
        result.check_actual()
        with open(file_name, "wb") as stream:
            pickle.dump(result, stream, protocol=pickle.HIGHEST_PROTOCOL)
        return result
