# coding: utf-8

from __future__ import absolute_import, print_function

import logging

from cached_property import cached_property
import click

import infra.rtc.iolimit_ticketer.utils as utils
import infra.rtc.iolimit_ticketer.yp_model as yp_model
import infra.rtc.iolimit_ticketer.hm_model as hm_model
import infra.rtc.iolimit_ticketer.walle_model as walle_model
import infra.rtc.iolimit_ticketer.awacs_services as awacs_services


class CliContext(object):

    def __init__(self):
        self.dry_run = True

    def read_tokens(self):
        utils.read_token()
        utils.read_st_token()
        utils.read_nanny_token()
        utils.read_ok_token()

    @cached_property
    def io_limit_map(self):
        return utils.get_io_limit_map()

    @cached_property
    def net_limit_map(self):
        return utils.get_net_limit_map()

    @cached_property
    def quota_map(self):
        return utils.get_quota_map()

    @cached_property
    def abc_members(self):
        return utils.get_abc_members_cached()

    @cached_property
    def abc_services(self):
        return utils.get_abc_services_cached()

    @cached_property
    def abc_responsibles(self):
        return utils.get_abc_responsibles_cached()

    @cached_property
    def yp_stat(self):
        return yp_model.get_yp_stat_cached()

    @cached_property
    def hm_stat(self):
        return hm_model.get_hm_stat_cached()

    @cached_property
    def walle_stat(self):
        return walle_model.get_walle_stat_cached()

    @cached_property
    def awacs_services(self):
        return awacs_services.get_awacs_services_cached()


@click.group()
@click.option('--dry-run/--no-dry-run', default=True)
@click.pass_context
def cli(ctx, dry_run):
    """
    IOLimit tickenator.
    """
    ctx.obj.dry_run = dry_run
    logging.info("dry run: %r", ctx.obj.dry_run)
    ctx.obj.read_tokens()
