# coding: utf-8

from __future__ import absolute_import, print_function

import sys
from collections import defaultdict

import click
from yaml import safe_dump

from infra.rtc.iolimit_ticketer.cli import cli


@cli.command()
@click.pass_context
def cohabitation(ctx):
    """Find projects on which cohabitation exists."""

    hosts_in_projects = defaultdict(lambda: defaultdict(int))
    walle_hosts = ctx.obj.walle_stat.host_map
    for node in ctx.obj.yp_stat.node_map.values():
        if node.segment not in ("default", "yt_arnold_colocation", "base-search-cohabitation"):
            continue
        walle_host = walle_hosts.get(node.fqdn)
        if walle_host:
            if node.segment == "yt_arnold_colocation" and "rtc.cohabitation-enabled" not in walle_host.tags and walle_host.project != "rtc-yt-mtn":
                print("{} {}".format(node.fqdn, walle_host.project))
            hosts_in_projects[node.segment][walle_host.project] += 1
        else:
            hosts_in_projects[node.segment]["<unknown>"] += 1

    safe_dump({"projects": {str(segment): dict(x) for segment, x in hosts_in_projects.items()}}, sys.stdout, default_flow_style=False)
