
import json
from collections import Counter

import click
from infra.rtc.iolimit_ticketer.cli import cli

from infra.rtc.iolimit_ticketer.cli_net_tickets import filter_dev_pods


@cli.command('find_services_without_guarantees')
@click.option('--cluster')
@click.option('--most_common_number', default=30)
@click.pass_context
def find_services_without_guarantees(ctx, cluster, most_common_number):
    service_map = filter_dev_pods(ctx.obj.yp_stat.service_map)

    pod_counter = Counter()

    for service_headers, service in service_map.items():
        # TODO: пока начинаем с сервисов YP_LITE
        if service_headers[0] != "YP_LITE":
            continue

        account, service_pod_counter = service.account_id, 0

        for dc, dc_data in service.clusters.items():
            if dc != cluster:
                continue

            for pod in dc_data.pods.values():
                if not pod.has_net_guarantee():
                    service_pod_counter += 1

        pod_counter.update({account: service_pod_counter})

    most_populated = pod_counter.most_common(most_common_number)

    json.dump(most_populated, open("{0}_most_populated_services.json".format(cluster), "w"), indent=4)
