#!/home/dldmitry/walle_venv/bin/python
from __future__ import print_function

import os
import json
from collections import defaultdict

BEGEMOT_SERVICES = {
    'begemot-perf-test-beta-antirobot-2-yp',
    'begemot-perf-test-beta-bravo-2-yp',
    'begemot-perf-test-beta-cv-2-yp',
    'begemot-perf-test-beta-ethos-2-yp',
    'begemot-perf-test-beta-failcache-2-yp',
    'begemot-perf-test-beta-geo-2-yp',
    'begemot-perf-test-beta-lingboost-2-yp',
    'begemot-perf-test-beta-megamind-2-yp',
    'begemot-perf-test-beta-merger-2-yp',
    'begemot-perf-test-beta-mf-2-yp',
    'begemot-perf-test-beta-mf2-2-yp',
    'begemot-perf-test-beta-service-2-yp',
    'begemot-perf-test-beta-spellchecker-2-yp',
    'begemot-perf-test-beta-thesaurus-2-yp',
    'begemot-perf-test-beta-webfresh-2-yp',
    'begemot-perf-test-beta-wizard-2-yp',
    'begemot-webfresh-priemka-1',
    'begemot-webfresh-priemka-2',
    'begemot-webfresh-priemka-3',
    'begemot-webfresh-priemka-4',
    'begemot-webfresh-priemka-5',
    'begemot-webfresh-priemka-6',
    'begemot_bravo_yp_hamster',
    'begemot_bravo_yp_priemka_1',
    'begemot_bravo_yp_priemka_2',
    'begemot_bravo_yp_priemka_3',
    'begemot_bravo_yp_priemka_4',
    'begemot_bravo_yp_priemka_5',
    'begemot_bravo_yp_priemka_6',
    'begemot_bravo_yp_prod_man',
    'begemot_bravo_yp_prod_sas',
    'begemot_bravo_yp_prod_vla',
    'begemot_cv_yp_hamster',
    'begemot_cv_yp_priemka_1',
    'begemot_cv_yp_priemka_2',
    'begemot_cv_yp_priemka_3',
    'begemot_cv_yp_priemka_4',
    'begemot_cv_yp_priemka_5',
    'begemot_cv_yp_priemka_6',
    'begemot_cv_yp_prod_man',
    'begemot_cv_yp_prod_sas',
    'begemot_cv_yp_prod_vla',
    'begemot_ethos_yp_hamster',
    'begemot_ethos_yp_priemka_man_1',
    'begemot_ethos_yp_priemka_man_2',
    'begemot_ethos_yp_priemka_vla_1',
    'begemot_ethos_yp_priemka_vla_2',
    'begemot_ethos_yp_priemka_vla_3',
    'begemot_ethos_yp_priemka_vla_4',
    'begemot_ethos_yp_priemka_vla_5',
    'begemot_ethos_yp_prod_man',
    'begemot_ethos_yp_prod_sas',
    'begemot_ethos_yp_prod_vla',
    'begemot_failcache_yp_prod_man',
    'begemot_failcache_yp_prod_sas',
    'begemot_failcache_yp_prod_vla',
    'begemot_geo_testing',
    'begemot_geowizard_testing',
    'begemot_lingboost_yp_hamster',
    'begemot_lingboost_yp_priemka_1',
    'begemot_lingboost_yp_priemka_2',
    'begemot_lingboost_yp_priemka_3',
    'begemot_lingboost_yp_priemka_4',
    'begemot_lingboost_yp_priemka_5',
    'begemot_lingboost_yp_priemka_6',
    'begemot_lingboost_yp_prod_man',
    'begemot_lingboost_yp_prod_sas',
    'begemot_lingboost_yp_prod_vla',
    'begemot_merger_priemka_1',
    'begemot_merger_priemka_2',
    'begemot_merger_priemka_3',
    'begemot_merger_priemka_4',
    'begemot_merger_priemka_5',
    'begemot_merger_priemka_6',
    'begemot_merger_yp_hamster',
    'begemot_merger_yp_prod_man',
    'begemot_merger_yp_prod_sas',
    'begemot_merger_yp_prod_vla',
    'begemot_mf2_yp_hamster',
    'begemot_mf2_yp_priemka_1',
    'begemot_mf2_yp_priemka_2',
    'begemot_mf2_yp_priemka_3',
    'begemot_mf2_yp_priemka_4',
    'begemot_mf2_yp_priemka_5',
    'begemot_mf2_yp_priemka_6',
    'begemot_mf2_yp_prod_man',
    'begemot_mf2_yp_prod_sas',
    'begemot_mf2_yp_prod_vla',
    'begemot_mf2_yp_testing',
    'begemot_mf_yp_hamster',
    'begemot_mf_yp_priemka_1',
    'begemot_mf_yp_priemka_2',
    'begemot_mf_yp_priemka_3',
    'begemot_mf_yp_priemka_4',
    'begemot_mf_yp_priemka_5',
    'begemot_mf_yp_priemka_6',
    'begemot_mf_yp_prod_man',
    'begemot_mf_yp_prod_sas',
    'begemot_mf_yp_prod_vla',
    'begemot_mf_yp_testing',
    'begemot_service_yp_hamster',
    'begemot_service_yp_priemka_1',
    'begemot_service_yp_priemka_2',
    'begemot_service_yp_priemka_3',
    'begemot_service_yp_priemka_4',
    'begemot_service_yp_priemka_5',
    'begemot_service_yp_priemka_6',
    'begemot_service_yp_prod_man',
    'begemot_service_yp_prod_sas',
    'begemot_service_yp_prod_vla',
    'begemot_spellchecker_priemka_1',
    'begemot_spellchecker_priemka_2',
    'begemot_spellchecker_priemka_p3',
    'begemot_spellchecker_priemka_p4',
    'begemot_src_setup_yp_hamster',
    'begemot_thesaurus_yp_hamster',
    'begemot_thesaurus_yp_priemka_1',
    'begemot_thesaurus_yp_priemka_2',
    'begemot_thesaurus_yp_priemka_3',
    'begemot_thesaurus_yp_priemka_4',
    'begemot_thesaurus_yp_priemka_5',
    'begemot_thesaurus_yp_priemka_6',
    'begemot_thesaurus_yp_prod_man',
    'begemot_thesaurus_yp_prod_sas',
    'begemot_thesaurus_yp_prod_vla',
    'begemot_webfresh_yp_prod_man',
    'begemot_webfresh_yp_prod_sas',
    'begemot_webfresh_yp_prod_vla',
    'begemot_wizard_yp_hamster',
    'begemot_wizard_yp_priemka_1',
    'begemot_wizard_yp_priemka_2',
    'begemot_wizard_yp_priemka_3',
    'begemot_wizard_yp_priemka_4',
    'begemot_wizard_yp_priemka_5',
    'begemot_wizard_yp_priemka_6',
    'begemot_wizard_yp_prod_man',
    'begemot_wizard_yp_prod_sas',
    'begemot_wizard_yp_prod_vla',
    'begemot_wizard_yp_testing',
    'bg_market_lingboost_yp_prod_man',
    'bg_market_lingboost_yp_prod_sas',
    'bg_market_lingboost_yp_prod_vla',
    'bg_market_merger_yp_prod_man',
    'bg_market_merger_yp_prod_sas',
    'bg_market_merger_yp_prod_vla',
    'bg_market_service_yp_prod_man',
    'bg_market_service_yp_prod_sas',
    'bg_market_service_yp_prod_vla',
    'bg_market_wizard_yp_prod_man',
    'bg_market_wizard_yp_prod_sas',
    'bg_market_wizard_yp_prod_vla',
    'bg_market_wizard_yp_testing',
    'man-begemot-thesaurus-worker-p-2-yp',
    'perf_logger_web_yp_hamster_man',
    'perf_logger_web_yp_hamster_sas',
    'perf_logger_web_yp_hamster_vla',
    'perf_logger_web_yp_prod_man',
    'perf_logger_web_yp_prod_sas',
    'spellchecker_http_man',
    'spellchecker_http_sas',
    'spellchecker_http_vla',
    'spellcheckereng_production_man',
    'spellcheckereng_production_sas',
    'spellcheckereng_production_vla',
    'spellcheckermisc1_production_man',
    'spellcheckermisc1_production_sas',
    'spellcheckermisc1_production_vla',
    'spellcheckerrus_for_exps',
    'spellcheckerrus_production_man',
    'spellcheckerrus_production_sas',
    'spellcheckerrus_production_vla',
    'vla-begemot-priemka-worker-wizard-2-1-beta-yp'
}

CONTAINER_MAP = defaultdict(int)


def fix_storage_class(storage_class):
    if storage_class == "nvme":
        return "ssd"
    else:
        return storage_class


def process_spec(spec):
    hostname = spec["hostname"]
    resources = spec["resources"]
    if not resources:
        return

    service_map = {}
    for resource in resources:
        if not resource["resource_capacity"]:
            continue

        storage_class = fix_storage_class(resource["storage_class"])
        if storage_class != "ssd":
            continue

        deploy_engine = resource["deploy_engine"]
        service_id = resource["service_id"]
        resource_uuid = resource["uuid"]
        if not resource_uuid or not deploy_engine or not service_id:
            continue

        container_fqdn = resource["container_fqdn"] or hostname
        if service_id not in BEGEMOT_SERVICES:
            continue

        CONTAINER_MAP[container_fqdn] += resource["resource_capacity"]


def main():
    root_path = "data"
    for name in os.listdir(root_path):
        if "sas" not in name:
            continue
        spec = json.load(open("{}/{}".format(root_path, name)))
        process_spec(spec)

    print(json.dumps(dict(CONTAINER_MAP), indent=4))


if __name__ == "__main__":
    main()

