# -*- coding: utf-8 -*-

import requests


class QloudClient():
    __url = "https://{}.yandex-team.ru/api/management/{}"
    __headers = {"Content-Type": "application/json;charset=UTF-8"}

    def __init__(self, useragent, oauth_token):
        self.__headers["User-Agent"] = useragent
        self.__headers["Authorization"] = 'OAuth {}'.format(oauth_token)
        self.cache = {}

    def call(self, method, hand, installation, params=None, data=None):
        url = self.__url.format(installation, hand)
        try:
            resp = requests.request(method, url, headers=self.__headers, params=params, data=data)
            resp.raise_for_status()
        except Exception:
            raise
        else:
            result = self._parse_resp(resp)
        return result

    def _parse_resp(self, resp):
        return resp.json()

    def get_segments(self, installation):
        if installation not in self.cache:
            resp = self.call('GET', 'deployTypes', installation)
            self.cache[installation] = [i['deployType'] for i in resp]
        # TODO add exceptions
        return self.cache[installation]
