# -*- coding: utf-8 -*-

import requests
from requests.exceptions import RequestException


class ResolverClient():
    __url = "https://rtc-instance-resolver.in.yandex-team.ru/v1"
    __headers = {"Content-Type": "application/json;charset=UTF-8"}

    def __init__(self, useragent, tvm_token):
        self.__headers["X-Ya-Service-Ticket:"] = tvm_token
        self.__headers["User-Agent"] = useragent

    def call(self, method, hand, params=None, data=None):
        url = "{}/{}".format(self.__url, hand)
        try:
            resp = requests.request(method, url, headers=self.__headers, params=params, data=data)
        except RequestException as e:  # noqa
            # TODO
            pass
        return resp.json()

    def get_host_info(self, inv):
        host_instances = self.call('GET', '/host_instances/{}'.format(inv))
        return host_instances['Hosts']

    def iter_hosts_info(self, invs=[]):
        for inv in invs:
            yield self.get_host_info(inv)
