# coding: utf-8

from walle_api import WalleClient
from startrek_client import Startrek
from infra.rtc.janitor.constants import (
    PROG_NAME
)
from infra.rtc.janitor.clients.abc_client import AbcClient
from infra.rtc.janitor.clients.bot_client import BotClient
from infra.rtc.janitor.clients.resolver_client import ResolverClient
from infra.rtc.janitor.clients.qloud_client import QloudClient
from infra.rtc.janitor.clients.juggler_client import JugglerClient


class Context(object):

    def __init__(self, oauth_token, tvm_token, dry_run):
        self.walle_client = WalleClient(access_token=oauth_token)
        self.st_client = Startrek(useragent=PROG_NAME, token=oauth_token)
        self.resolver_client = ResolverClient(useragent=PROG_NAME, tvm_token=tvm_token)
        self.bot_client = BotClient(useragent=PROG_NAME, oauth_token=oauth_token)
        self.abc_client = AbcClient(useragent=PROG_NAME, oauth_token=oauth_token)
        self.qloud_client = QloudClient(useragent=PROG_NAME, oauth_token=oauth_token)
        self.juggler_client = JugglerClient(host='rtc-janitor-sandbox', service=None)
        self.dry_run = dry_run
        self.counters = {
            'parsed_tickets': 0,
            'processed_scenarios': 0,
            'scenarios_errors': [],
            'tickets_errors': []
        }
        self.hosts_info = {}
        self.scenarios_list = []
