# coding: utf-8

import logging
from .constants import (
    ADD_COMMENT_FOR_DUTY_TO_ST_STAGE,
    ACTION_PASS
)
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import (
    render_template,
    add_st_comment
)
from .misc import (get_inventories,
                   filter_hosts_has_tag,
                   filter_hosts_without_tag,
                   filter_hosts_in_walle,
                   filter_hosts_not_in_walle)

log = logging.getLogger(__name__)


def add_comment_for_duty_to_st_stage(context, scenario):
    task_name = scenario.labels['task_name']
    walle_hosts_non_rtc = get_inventories(filter_hosts_without_tag('rtc',
                                                                   context,
                                                                   get_inventories(filter_hosts_in_walle(context, scenario.hosts_list))))  # noqa
    rtc_hosts = get_inventories(filter_hosts_has_tag('rtc', context, scenario.hosts_list))
    other_hosts = get_inventories(filter_hosts_not_in_walle(context, scenario.hosts_list))

    message = render_template('{}_message.jinja'.format(task_name),
                              scenario=scenario,
                              issuer=scenario.issuer.strip('@'),
                              walle_hosts_non_rtc=walle_hosts_non_rtc,
                              rtc_hosts=rtc_hosts,
                              other_hosts=other_hosts)
    log.debug(message)
    if context.dry_run:
        return ACTION_PASS
    log.debug('Adding comment for DUTY to ST')
    add_st_comment(context.st_client, scenario.ticket_key, text=message)
    return finish_stage(scenario)


register_stage(ADD_COMMENT_FOR_DUTY_TO_ST_STAGE, add_comment_for_duty_to_st_stage)
