# coding: utf-8

import logging
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import (
    render_template,
    st_transistion
)
from .constants import (
    ADD_PREORDER_STAGE,
    ACTION_PASS
)

log = logging.getLogger(__name__)


def add_preorder_stage(context, scenario):
    preorder_id = scenario.script_args['preorder_id']
    target_project = scenario.script_args['target_project_id']
    if not scenario.script_args['whole_preorder']:
        log.debug('Not whole preorder will be processed. Manual actions needed. Ticket: %r, preorder ID: %r target Project %s', scenario.ticket_key, preorder_id, target_project)
        st_transistion(context.st_client, scenario.ticket_key, state='readyForDev')
        st_transistion(context.st_client, scenario.ticket_key, state='inProgress')
        return finish_stage(scenario)
    preorder = context.bot_client.get_preorder_info(preorder_id)
    # Check preorder status
    if preorder['status_id'] not in (3, 4):
        log.debug(
            'Preorder not ready, status_id not in (3, 4): %r(%s), preorder id: %r, ticket: %r, preorder ticket: %s',
            preorder['status_id'],
            preorder['status_code'],
            preorder_id,
            scenario.ticket_key,
            preorder['ticket_id']
        )
        message = render_template('add_preorder_message.jinja',
                                  text_case="PREORDER_NOT_READY",
                                  preorder_id=preorder_id,
                                  preorder_info=preorder,
                                  )
        log.debug(message)
        if context.dry_run:
            return ACTION_PASS
        log.debug('Change ticket %r state to closed', scenario.ticket_key)
        st_transistion(context.st_client, scenario.ticket_key, state='closed', resolution='invalid', comment=message)
        return finish_stage(scenario)
    # Add preorder
    context.walle_client.add_preorder(int(preorder_id), target_project, prepare=True, sudo=True, reason=scenario.ticket_key)
    message = render_template('add_preorder_message.jinja',
                              text_case="PREORDER_ADDED",
                              ticket_key=scenario.ticket_key,
                              preorder_id=preorder_id,
                              target_project=target_project,
                              preorder_info=preorder,
                              )
    log.debug(message)
    if context.dry_run:
        return ACTION_PASS
    log.debug('Change ticket %r state to processed', scenario.ticket_key)
    st_transistion(context.st_client, scenario.ticket_key, state='readyForDev')
    st_transistion(context.st_client, scenario.ticket_key, state='inProgress', message=message)
    return finish_stage(scenario)


register_stage(ADD_PREORDER_STAGE, add_preorder_stage)
