# coding: utf-8

import logging


from .constants import (
    ADD_RESPS_TO_ST_STAGE,
    ACTION_PASS
)
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import (
    get_hosts_info,
    hosts_info_group_by_prj,
    render_template,
    add_st_comment
)
from .misc import get_resps

log = logging.getLogger(__name__)


def add_resps_to_st_stage(context, scenario):
    hosts = get_hosts_info(context, scenario.hosts_list)
    hosts_info_by_prj = hosts_info_group_by_prj(context, hosts)
    resps = get_resps(scenario, hosts_info_by_prj, flags='noresp')
    message = render_template('need_approval_message.jinja',
                              hosts_info=hosts_info_by_prj,
                              )
    log.debug(message)
    if context.dry_run:
        return ACTION_PASS
    log.debug('Adding resps %s to ST', resps)
    add_st_comment(context.st_client, scenario.ticket_key, text=message, summonees=resps)
    return finish_stage(scenario)


register_stage(ADD_RESPS_TO_ST_STAGE, add_resps_to_st_stage)
