# coding: utf-8

import logging
from infra.rtc.janitor.constants import ST_TAGS_BY_SCENARIO_TYPE
from .constants import (
    ADD_TAGS_TO_ST_STAGE,
    ACTION_PASS
)
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import (
    add_st_tags)


log = logging.getLogger(__name__)


def add_tags_to_st_stage(context, scenario):
    if context.dry_run:
        return ACTION_PASS
    tags = ST_TAGS_BY_SCENARIO_TYPE.get(scenario.labels['task_name'], [])
    log.debug('Adding tags %s to ST', tags)
    add_st_tags(context.st_client, scenario.ticket_key, tags)
    return finish_stage(scenario)


register_stage(ADD_TAGS_TO_ST_STAGE, add_tags_to_st_stage)
