# coding: utf-8

import logging
from .constants import (
    CHECK_INTERSEPT_POWEROFF_STAGE
)
from .common import register_stage, finish_stage, terminate_fsm
from infra.rtc.janitor.common import (
    render_template,
    st_transistion,
    find_intersections_by_hosts,
    get_hosts_info,
    remove_st_janitor_processing,
)

log = logging.getLogger(__name__)


def check_intersept_poweroff_stage(context, scenario):

    intersections = find_intersections_by_hosts(context, scenario, janitor_owned=True, labels={'task_name': 'power_off'})
    if intersections:
        for i in intersections:
            i['hosts_info'] = get_hosts_info(context, i['hosts_ids'])
        message = render_template(
            'power_off_message.jinja',
            text_case="POWEROFF_CONFLICT",
            ticket_key=scenario.ticket_key,
            hosts_list=get_hosts_info(context, scenario.hosts_list),
            intersect_scenarios=intersections
        )
        st_transistion(context.st_client, scenario.ticket_key, state='closed', resolution='invalid', comment=message)
        remove_st_janitor_processing(context.st_client, scenario.ticket_key)
        return terminate_fsm(scenario)
    return finish_stage(scenario)


register_stage(CHECK_INTERSEPT_POWEROFF_STAGE, check_intersept_poweroff_stage)
