# coding: utf-8

import logging
from .constants import (
    CHECK_INTERSEPT_STARTED_STAGE
)
from .common import register_stage, finish_stage, retry_stage
from infra.rtc.janitor.common import (
    render_template,
    st_transistion,
    find_intersections_by_hosts,
    get_hosts_info
)

log = logging.getLogger(__name__)


def check_intersept_started_stage(context, scenario):
    intersections = find_intersections_by_hosts(context, scenario, status=('started',))
    if intersections:
        if scenario.fsm_prev_stage != scenario.fsm_curr_stage:  # First.time, make message
            for i in intersections:
                i['hosts_info'] = get_hosts_info(context, i['hosts_ids'])
            message = render_template(
                'power_off_message.jinja',
                text_case="HOST_SCENARIOS_CONFLICT",
                ticket_key=scenario.ticket_key,
                hosts_list=get_hosts_info(context, scenario.hosts_list),
                intersect_scenarios=intersections
            )
            st_transistion(context.st_client, scenario.ticket_key, state='blocked', comment=message)
        return retry_stage(scenario)  # ACTION_RETRY
    return finish_stage(scenario)


register_stage(CHECK_INTERSEPT_STARTED_STAGE, check_intersept_started_stage)
