# -*- coding: utf-8 -*-

import logging

from .constants import (
    CHECK_PERMS_FOR_HOSTS_STAGE,
    ACTION_PASS
)
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import (
    add_st_comment,
    hosts_info_group_by_prj,
    render_template
)

from .misc import (filter_hosts_without_tag,
                   filter_hosts_in_walle,
                   filter_hosts_not_in_walle)

log = logging.getLogger(__name__)


def check_perms_for_hosts_stage(context, scenario):
    hosts = filter_hosts_without_tag('rtc', context, scenario.hosts_list)
    walle_hosts_non_rtc = filter_hosts_without_tag('rtc',
                                                   context,
                                                   [i.get('inv') for i in filter_hosts_in_walle(context,
                                                                                                scenario.hosts_list)])
    other_hosts = filter_hosts_not_in_walle(context, scenario.hosts_list)

    if hosts:
        walle_hosts_non_rtc_by_prj = hosts_info_group_by_prj(context, walle_hosts_non_rtc)
        other_hosts_by_prj = hosts_info_group_by_prj(context, other_hosts)
        message = render_template('need_clean_hosts_message.jinja',
                                  walle_hosts_non_rtc_by_prj=walle_hosts_non_rtc_by_prj,
                                  other_hosts_by_prj=other_hosts_by_prj)
        log.debug(message)
        if context.dry_run:
            return ACTION_PASS
        add_st_comment(context.st_client, scenario.ticket_key, text=message)
    return finish_stage(scenario)


register_stage(CHECK_PERMS_FOR_HOSTS_STAGE, check_perms_for_hosts_stage)
