# -*- coding: utf-8 -*-

import logging
import pprint

from .constants import (
    ITDC_POWEROFF_ABC,
    CHECK_RESPONSIBLE_MEMBERSHP_STAGE,
)

from .common import register_stage, finish_stage, terminate_fsm
from infra.rtc.janitor.common import (
    render_template,
    add_st_comment,
    st_transistion,
    remove_st_janitor_processing,
    get_hosts_info,
)

log = logging.getLogger(__name__)


def check_responsible_membership_stage(context, scenario):
    responsible = scenario.labels['ticket_created_by']
    service_members = []
    log.debug('Access check')
    for abc in ITDC_POWEROFF_ABC:
        log.debug(pprint.pformat(abc))
        log.debug('Checking membership of user %s in ABC service %s, roles %s', responsible, str(abc['GROUP_SLUG']), abc['ROLES'])
        service_members.extend(context.abc_client.get_members(service_slug=abc['GROUP_SLUG'], roles=abc['ROLES']).itervalues())
    log.debug(pprint.pformat(service_members))
    for members in service_members:
        if responsible in members:
            log.debug('Access granted')
            return finish_stage(scenario)
    else:
        log.debug('Access denied')
        message = render_template(
            'power_off_message.jinja',
            text_case="ITCD_DENIED",
            ticket_key=scenario.ticket_key,
            hosts_list=get_hosts_info(context, scenario.hosts_list),
            responsible=responsible
        )
        st_transistion(context.st_client, scenario.ticket_key, state='closed', resolution='invalid', comment=message)
        try:
            add_st_comment(context.st_client, scenario.labels['ref_ticket_key'], text=message)
        except Exception as e:
            log.debug('Error while works with linked ticket: %r', e)
        remove_st_janitor_processing(context.st_client, scenario.ticket_key)
    return terminate_fsm(scenario)


register_stage(CHECK_RESPONSIBLE_MEMBERSHP_STAGE, check_responsible_membership_stage)
