# -*- coding: utf-8 -*-

import logging

from .constants import (
    CHECK_TASK_COUNT_STAGE,
    ITDC_POWEROFF_MAX_TASKS,
    CHECK_INTERSEPT_STARTED_STAGE
)

from .common import (
    register_stage,
    finish_stage,
    retry_stage,
    append_stage,
    )

from infra.rtc.janitor.common import (
    render_template,
    add_st_comment,
    st_transistion,
    get_hosts_info,
)

log = logging.getLogger(__name__)


def check_task_count_stage(context, scenario):
    simultaneous_scenarios_started = filter(lambda s: s.labels.get('task_name', '') == 'power_off' and s.status == 'started', context.scenarios_list)
    queued_scenarios = filter(lambda s: s.labels.get('task_name', '') == 'power_off' and s.status == 'created', context.scenarios_list)
    log.debug('Simultaneous Scenarios Started %s: %s', len(simultaneous_scenarios_started), ', '.join(['#{} {}'.format(s.scenario_id, s.ticket_key) for s in simultaneous_scenarios_started]))
    log.debug('Queued Scenarios %s: %s', len(queued_scenarios), ', '.join(['#{} {}'.format(s.scenario_id, s.ticket_key) for s in queued_scenarios]))
    scenario_retried = scenario.fsm_prev_stage == scenario.fsm_curr_stage
    tasks_overcount = len(simultaneous_scenarios_started) >= ITDC_POWEROFF_MAX_TASKS
    if not tasks_overcount and not scenario_retried:
        # стартует сценарий;
        message = render_template(
            'power_off_message.jinja',
            text_case="ITDC_CMS",
            ticket_key=scenario.ticket_key,
            hosts_ids=scenario.hosts_list,
            hosts_list=get_hosts_info(context, scenario.hosts_list),
        )
        st_transistion(context.st_client, scenario.ticket_key, state='inProgress', comment=message)
        try:
            add_st_comment(context.st_client, scenario.labels['ref_ticket_key'], text=message)
        except Exception as e:
            log.debug('Error while works with linked ticket: %r', e)
        return finish_stage(scenario)
    elif not tasks_overcount and scenario_retried:
        append_stage(context.walle_client, scenario, CHECK_INTERSEPT_STARTED_STAGE, CHECK_TASK_COUNT_STAGE)
        return finish_stage(scenario)
    elif tasks_overcount and not scenario_retried:
        message = render_template(
            'power_off_message.jinja',
            text_case="ITDC_OVER",
            ticket_key=scenario.ticket_key,
            hosts_list=get_hosts_info(context, scenario.hosts_list),
            active_scenarios=len(simultaneous_scenarios_started),
            queued_scenarios=len(queued_scenarios)
            )
        st_transistion(context.st_client, scenario.ticket_key, state='blocked', comment=message)
        try:
            add_st_comment(context.st_client, scenario.labels['ref_ticket_key'], text=message)
        except Exception as e:
            log.debug('Error while works with linked ticket: %r', e)
        return retry_stage(scenario)  # ACTION_RETRY
    else:
        return retry_stage(scenario)  # ACTION_RETRY


register_stage(CHECK_TASK_COUNT_STAGE, check_task_count_stage)
