# -*- coding: utf-8 -*-

import logging

from .constants import (
    CHECK_TO_MNT_COMPLETE
)
from .common import register_stage, finish_stage, retry_stage

from infra.rtc.janitor.common import (
    # st_transistion,
    render_template,
    add_st_comment, get_hosts_info
)

log = logging.getLogger(__name__)


def check_to_mnt_complete_stage(context, scenario):
    # дожидается момента, когда cms отдаст хост;
    # окончание сценария
    if scenario.status == 'finished':
        log.debug('''All hosts in maintenance''')
        message = render_template(
            'power_off_message.jinja',
            ticket_key=scenario.ticket_key,
            text_case="ALL_COMPLETE",
            hosts_list=get_hosts_info(context, scenario.hosts_list),
        )  # ALL_COMPLETE
        # st_transistion(context.st_client, scenario.ticket_key, state='close', resolution='fixed', comment=message)
        add_st_comment(context.st_client, scenario.ticket_key, text=message)
        try:
            add_st_comment(context.st_client, scenario.labels['ref_ticket_key'], text=message)
        except Exception as e:
            log.debug('Error while works with linked ticket: %r', e)
        log.debug(message)
        message = render_template(
            'power_off_message.jinja',
            text_case="RTC_COMPLETE",
            ticket_key=scenario.ticket_key,
            hosts_list=get_hosts_info(context, scenario.hosts_list),
            hosts_ids=scenario.hosts_list,
        )
        add_st_comment(context.st_client, scenario.ticket_key, text=message)
        log.debug(message)
        return finish_stage(scenario)
    else:
        log.debug('''Waiting hosts to maintenance transition''')
        return retry_stage(scenario)  # ACTION_RETRY


register_stage(CHECK_TO_MNT_COMPLETE, check_to_mnt_complete_stage)
