# coding: utf-8

import logging
from .constants import (
    CREATE_SCENARIO_STAGE,
    ACTION_PASS
)
from .common import register_stage, finish_stage

log = logging.getLogger(__name__)


def create_scenario_stage(context, scenario):
    scenario.create_walle_scenario(context.walle_client)
    if context.dry_run:
        return ACTION_PASS
    return finish_stage(scenario)


register_stage(CREATE_SCENARIO_STAGE, create_scenario_stage)
