from infra.rtc.janitor.common import get_hosts_info


def filter_hosts_in_walle(*args):
    return [h for h in get_hosts_info(*args) if h.get('w_prj')]


def filter_hosts_not_in_walle(*args):
    return [h for h in get_hosts_info(*args) if not h.get('w_prj')]


def get_inventories(hosts):
    return [h.get('inv') for h in hosts]


def get_resps(scenario, hosts_info_by_prj, flags='default'):
    """
        return: List
        flags = :str: 'default' - default, return responsible from scenario or (if not exist) responsibles from servers
                :str: 'addresp' - return responsibles from servers and add responsible from scenario
                :str: 'noresp'  - return responsibles from servers and EXCLUDE responsible from scenario
    """
    resp = scenario.labels.get('responsible', None)
    if resp and flags == 'default':
        return resp
    resps_list = set()
    for data in hosts_info_by_prj.values():
        if data['service_owners']:
            resps_list.update(data['service_owners'])
        else:
            resps_list.update(data['hw_owners'])
    if flags == 'addresp' and resp:
        resps_list.add(resp)
    elif flags == 'noresp' and resp:
        resps_list.difference_update((resp,))
    return list(resps_list)


def filter_hosts_without_tag(tag, *args):
    result = []
    for host in get_hosts_info(*args):
        if not host.get('fqdn'):
            continue
        if tag not in host.get('w_prj_tags'):
            result.append(host)
    return result


def filter_hosts_has_tag(tag, *args):
    result = []
    for host in get_hosts_info(*args):
        if not host.get('fqdn'):
            continue
        if tag in host.get('w_prj_tags'):
            result.append(host)
    return result


def list_hosts_racks(*args):
    result = set()
    for host in get_hosts_info(*args):
        if not host.get('fqdn'):
            continue
        result.add(host['rack'])
    return list(result)
