# -*- coding: utf-8 -*-

import logging
from .constants import (
    PROCESS_MULTIDC_TICKET,
)
from infra.rtc.janitor.constants import (
    MULTI_DC_TICKET_SUBTICKET_TAG,
)
from infra.rtc.janitor.common import (
    st_get_linked_multidc_subtickets,
    render_template,
    st_transistion,
)
from .common import (
    register_stage,
    finish_stage,
    terminate_fsm,
    )

log = logging.getLogger(__name__)


def process_multi_dc_ticket_stage(context, scenario):
    subtickets = st_get_linked_multidc_subtickets(context.st_client, scenario.ticket_key, MULTI_DC_TICKET_SUBTICKET_TAG)
    if not subtickets:
        log.error('No one subticket exist/acessible')
        raise Exception('No one subticket exist/acessible')
    for subticket in subtickets:
        if subticket['ticket'].status.key != 'closed':
            log.debug('ticket %r: some subtickets are still not closed', scenario.ticket_key)
            return terminate_fsm(scenario)
    log.debug('ticket %r: all subtickets closed', scenario.ticket_key)
    message = render_template('multi_dc_subticket_message.jinja')
    st_transistion(context.st_client, scenario.ticket_key, state='closed', comment=message, resolution='fixed')
    return finish_stage(scenario)


register_stage(PROCESS_MULTIDC_TICKET, process_multi_dc_ticket_stage)
