# -*- coding: utf-8 -*-

import logging

from .constants import (
    REMOVE_PROCESSING_TAG
)
from .common import register_stage, finish_stage

from infra.rtc.janitor.common import (
    remove_st_tags,
)

from infra.rtc.janitor.constants import (
    JANITOR_PROCESSING_TAG,
)

log = logging.getLogger(__name__)


def remove_processing_tag_stage(context, scenario):
    log.debug('''Removing Janitor processing marking tag {} from ticket {}'''.format(JANITOR_PROCESSING_TAG, scenario.ticket_key))
    remove_st_tags(context.st_client, scenario.ticket_key, (JANITOR_PROCESSING_TAG, ))
    return finish_stage(scenario)


register_stage(REMOVE_PROCESSING_TAG, remove_processing_tag_stage)
