# coding: utf-8

import logging
from .constants import (
    RESOLVE_ABC_ID_STAGE,
)
from .common import register_stage, finish_stage  # , terminate_fsm
# from infra.rtc.janitor.common import (
#     render_template,
#     st_transistion,
#     remove_st_janitor_processing
# )
# from walle_api import WalleApiError

log = logging.getLogger(__name__)


def resolve_abc_id_stage(context, scenario):
    if 'abc_service_name' in scenario.labels:
        log.debug('Resolve ABC service ID by name')
        abc_service_info = context.abc_client.get_service_info(name=scenario.labels['abc_service_name'])
        scenario.script_args['abc_service_id'] = abc_service_info['id']
        log.debug('Service name: {}, service ID:{}'.format(scenario.labels['abc_service_name'], scenario.script_args['abc_service_id']))
        log.debug('Service info:{}'.format(abc_service_info))
    else:
        log.debug('No ABC service name provided')
    return finish_stage(scenario)


register_stage(RESOLVE_ABC_ID_STAGE, resolve_abc_id_stage)
