# coding: utf-8

import logging
from .constants import (
    RESOLVE_HOSTS_STAGE
)
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import get_hosts_info

log = logging.getLogger(__name__)


def resolve_hosts_stage(context, scenario):
    log.debug('Resolve host names to invs, remove duplicates')

    host_invs = set()
    for item in get_hosts_info(context, scenario.hosts_list):
        host_invs.add(int(item['inv']))
    scenario.hosts = [{'inv': i} for i in host_invs]
    return finish_stage(scenario)


register_stage(RESOLVE_HOSTS_STAGE, resolve_hosts_stage)
