# -*- coding: utf-8 -*-

import logging

from .constants import (
    REG_OPS_SERVICE_SLUG_OF_DUTY,
    SET_DUTY_AS_ASSIGNEE
)
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import (
    st_set_assignee
)

log = logging.getLogger(__name__)


def set_duty_as_assignee_stage(context, scenario):
    duty_service_id = context.abc_client.service_slug_to_id(REG_OPS_SERVICE_SLUG_OF_DUTY)
    duty = context.abc_client.get_duty(duty_service_id)
    st_set_assignee(context.st_client, scenario.ticket_key, assignee_login=duty['login'])
    log.debug('Scenario %r, to ticket %s set assignee %s %s as duty of %s service', scenario.scenario_id, scenario.ticket_key, duty['login'], duty['name_en'], REG_OPS_SERVICE_SLUG_OF_DUTY)
    return finish_stage(scenario)


register_stage(SET_DUTY_AS_ASSIGNEE, set_duty_as_assignee_stage)
