# coding: utf-8

import logging
from .constants import (
    START_SCENARIO_STAGE,
    ACTION_PASS
)
from .common import register_stage, finish_stage

log = logging.getLogger(__name__)


def start_scenario_stage(context, scenario):
    if context.dry_run:
        return ACTION_PASS
    log.debug('Starting scenario #%s %s, %s', scenario.scenario_id, scenario.name, scenario.ticket_key)
    scenario.start(context.walle_client)
    return finish_stage(scenario)


register_stage(START_SCENARIO_STAGE, start_scenario_stage)
