# coding: utf-8

import logging
from .constants import (
    VALIDATE_DESTINATION_PROJECT_STAGE,
    QLOUD_MAP,
)
from .common import register_stage, finish_stage, terminate_fsm
from infra.rtc.janitor.common import (
    render_template,
    st_transistion,
    remove_st_janitor_processing
)
from walle_api import WalleApiError

log = logging.getLogger(__name__)


def validate_destination_project_stage(context, scenario):
    log.debug('validate_destination_project')
    if 'target_project_id' in scenario.script_args:
        log.debug('Qloud project flow: %s', scenario.script_args['target_project_id'])
        if '.' in scenario.script_args['target_project_id']:
            qloud_installation, qloud_segment = scenario.script_args['target_project_id'].split('.')
            log.debug('Qloud installation: %s, Qloud segment: %s, ', qloud_installation, qloud_segment)
            qloud_mapped_inst = QLOUD_MAP.get(qloud_installation, None)
            if qloud_mapped_inst:
                aval_qloud_segments = context.qloud_client.get_segments(qloud_installation)
                log.debug('Avaliable segments in installation: %s,', aval_qloud_segments)
                if qloud_segment in aval_qloud_segments:
                    log.debug('Add parameters for Qloud host-add')
                    del(scenario.script_args['target_project_id'])
                    scenario.script_args['target_hardware_segment'] = "{}.{}".format(qloud_mapped_inst, qloud_segment)
                    log.debug('New scenario: %r', scenario)
                else:
                    # No segment
                    log.debug('Qloud segment %s not found in installation %s', qloud_segment, qloud_installation)
                    message = render_template('qloud_segment_not_exist.jinja', qloud_installation=qloud_installation, qloud_segment=qloud_segment)
                    log.debug('Ticket %s transited to `NEED INFO`, user %s noted', scenario.ticket_key, scenario.labels['ticket_created_by'])
                    st_transistion(context.st_client, scenario.ticket_key, state='need_info', comment=message, summonees=scenario.labels['ticket_created_by'])
                    log.debug(message)
                    return terminate_fsm(scenario)
            else:
                # No hw installation
                log.debug('Qloud installation not found %s, avaliable installations: %s',  qloud_installation, QLOUD_MAP.keys())
                message = render_template('qloud_installation_not_exist.jinja', qloud_installation=qloud_installation, qloud_installations_aval=QLOUD_MAP.keys())
                log.debug('Ticket %s transited to `CLOSED`, user %s noted', scenario.ticket_key, scenario.labels['ticket_created_by'])
                st_transistion(context.st_client, scenario.ticket_key, state='closed', resolution='invalid', comment=message, summonees=scenario.labels['ticket_created_by'])
                log.debug(message)
                remove_st_janitor_processing(context.st_client, scenario.ticket_key)
                return terminate_fsm(scenario)
        else:
            try:
                context.walle_client.get_project(id=scenario.script_args['target_project_id'])
            except WalleApiError:
                message = render_template('project_not_exist.jinja', target_project_id=scenario.script_args['target_project_id'])
                log.debug('arg %s,\nmsg %s', scenario.script_args['target_project_id'], message)
                st_transistion(context.st_client, scenario.ticket_key, state='closed', resolution='invalid', comment=message)
                log.debug('Destination project for scenario not exist: %s', scenario.script_args['target_project_id'])
                remove_st_janitor_processing(context.st_client, scenario.ticket_key)
                return terminate_fsm(scenario)
    return finish_stage(scenario)


register_stage(VALIDATE_DESTINATION_PROJECT_STAGE, validate_destination_project_stage)
