# coding: utf-8

import logging
from .constants import (
    VALIDATE_SCENARIO_STAGE,
)
from .common import register_stage, finish_stage, terminate_fsm
from infra.rtc.janitor.common import (
    render_template,
    st_transistion,
    find_intersections_by_hosts,
    get_hosts_info
)

log = logging.getLogger(__name__)


def validate_scenario_stage(context, scenario):

    intersections = find_intersections_by_hosts(context, scenario)
    if intersections:
        for i in intersections:
            i['hosts_info'] = get_hosts_info(context, i['hosts_ids'])
        message = render_template('hosts_interseption.jinja', intersect_scenarios=intersections)
        st_transistion(context.st_client, scenario.ticket_key, state='closed', resolution='invalid', comment=message)
        return terminate_fsm(scenario)
    return finish_stage(scenario)


register_stage(VALIDATE_SCENARIO_STAGE, validate_scenario_stage)
