# coding: utf-8

import logging
from .constants import (
    VALIDATE_TICKET_STAGE
)
from .common import register_stage, finish_stage
from infra.rtc.janitor.common import create_ticket

log = logging.getLogger(__name__)


def validate_ticket_stage(context, scenario):
    if not scenario.ticket_key:
        ticket_key = create_ticket(context)
        log.info('Ticket %s created', ticket_key)
        scenario.ticket_key = ticket_key
    return finish_stage(scenario)


register_stage(VALIDATE_TICKET_STAGE, validate_ticket_stage)
