# -*- coding: utf-8 -*-

import mock
import sys


def monkeypatch_function(monkeypatch, func, module=None, **mock_kwargs):
    if module is None:
        module = sys.modules[func.__module__]
    func_mock = mock.create_autospec(func, spec_set=True, **mock_kwargs)
    monkeypatch.setattr(module, func.__name__, func_mock)
    return func_mock
