from library.python.svn_version import svn_revision
from juggler.bundles import cli, Manifest

from . import bind
from . import bundle_info
from . import cron
from . import cron_errs
from . import ll_duplicate_addr
from . import hbf_agent_rtc
from . import ntp
from . import walle_hotfix
from . import is_file
from . import eth_errors
from . import portod_tasks
from . import tcp_sampler_dump
from . import numa_memorybw


def create_manifest():
    manifest = Manifest(name="rtc-juggler-checks", build_number=svn_revision())

    manifest.register(bundle_info.juggler_check)
    manifest.register(ll_duplicate_addr.juggler_check)
    manifest.register(hbf_agent_rtc.juggler_check)
    manifest.register(cron.juggler_check)
    manifest.register(cron_errs.juggler_check)
    manifest.register(walle_hotfix.juggler_check)
    manifest.register(bind.juggler_check)
    manifest.register(ntp.juggler_check)
    manifest.register(is_file.juggler_check)
    manifest.register(eth_errors.juggler_check)
    manifest.register(portod_tasks.juggler_check)
    manifest.register(tcp_sampler_dump.juggler_check)
    manifest.register(numa_memorybw.juggler_check)

    return manifest


def main():
    cli(obj=create_manifest())
