"""
Local DNS resolver check

"""
from juggler.bundles import as_check, Status
from infra.rtc.juggler.bundle.util import WalleCompatEvent
from subprocess import run


CHECK_NAME = 'bind'
DNSMANAGER_CHECK = "/opt/yandex-dns-manager/dnsmanager check"


@as_check(name=CHECK_NAME)
def juggler_check(*arguments):
    status = Status.OK
    msg = ""
    try:
        cmd = run(DNSMANAGER_CHECK.split(), capture_output=True)
        if cmd.returncode != 0:
            status = Status.CRIT
            msg = cmd.stdout.strip().decode("utf-8")
    except Exception as e:
        status = Status.CRIT
        msg = str(e)
    return WalleCompatEvent(status, msg)
