"""
Juggler checks bundle revision check. Used to control bundle deploy and locate
hosts with outdated bundles.

https://st.yandex-team.ru/RUNTIMECLOUD-8192

"""
from library.python.svn_version import svn_revision
from juggler.bundles import as_check, Status, Event


CHECK_NAME = 'bundle_info'


@as_check(name=CHECK_NAME, run_always=True)
def juggler_check():
    return Event(
        Status.OK,
        __file__.rsplit('/', 3)[0] + '@' + str(svn_revision()),
        tags=['HOSTMAN-516'],
    )
