"""
Cron daemon status check.

"""
from infra.rtc.juggler.bundle.util import get_file_content, get_process_info
from juggler.bundles import as_check, Status, Event as JugglerEvent


CHECK_NAME = 'cron'
GLOBAL_TAGS = ['HOSTMAN-516']  # this check involved in monitoring coverage
PID_FILE = '/var/run/crond.pid'


class Event(JugglerEvent):
    def __init__(self, *args, tags=None, **kwargs):
        tags = GLOBAL_TAGS if tags is None else tags + GLOBAL_TAGS
        super().__init__(*args, tags=tags, **kwargs)


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        pid = int(get_file_content(PID_FILE))
    except Exception as e:  # no matter which exactly
        return Event(Status.CRIT, "Failed to read pid file: " + str(e))

    try:
        info = get_process_info(pid, attrs=('name', 'status'))
    except Exception as e:  # no matter which exactly
        return Event(Status.CRIT, "Failed to get process info: " + str(e))

    if info['status'] == '?':
        return Event(Status.CRIT, "Process is absent")

    if info['name'] != 'cron':
        return Event(Status.CRIT, "Pidfile contain pid for another process")

    if info['status'] in ['sleeping', 'running']:
        return Event(Status.OK, 'Ok')

    return Event(Status.CRIT, "Bad process status: " + info['status'])
