"""
Cron errors reports check.

"""
import os
import time

from juggler.bundles import as_check, Status, Event


CHECK_NAME = 'cron_errs'
MAILS_FILE = '/var/log/fs_mail/fs_mail.dump'
IGNORE_OLDER_THAN_SEC = 60 * 60 * 24 * 4  # ignore old messages


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        stat = os.stat(MAILS_FILE)

        if stat.st_size > 0:
            if stat.st_mtime + IGNORE_OLDER_THAN_SEC > time.time():
                return Event(Status.CRIT, "Details in " + MAILS_FILE)
    except FileNotFoundError:
        pass
    except Exception as e:
        return Event(Status.CRIT, str(e))

    return Event(Status.OK, 'Ok')
