"""
Check hbf agent status on RTC
"""

import requests
import time
import porto

from juggler.bundles import as_check, Status, Event

CHECK_NAME = 'hbf_agent_rtc'

STATUS_MAP = {
    0: Status.OK,
    1: Status.WARN,
    2: Status.CRIT,
}


class JugglerHBFCheck(object):

    status_url = "http://localhost:9876/status"
    status = 0
    message = ""
    max_timedelta_of_updates = 600
    hbf_porto_container_name = 'yandex-hbf-agent'

    def check_is_hbf_running(self):
        try:
            c = porto.Connection()
            found = c.Find(self.hbf_porto_container_name)
            return found.GetProperty('state') == 'running'
        except Exception:
            return False

    def check_hbf_status(self):
        try:
            r = requests.get(self.status_url, timeout=2)
            if r.status_code == requests.codes.ok:
                answer = r.json()
                status = answer['status']
                desc = answer['desc']
                last_update = answer['last_update']

                msg = "HBF status is: {}, {}"
                if status == 'WARN':
                    return (1, msg.format(status, desc))
                elif status in ('CRIT', 'DISABLED'):
                    return (2, msg.format(status, desc))

                time_delta = time.time() - last_update
                if time_delta > self.max_timedelta_of_updates:
                    return (2, "HBF last update timestamp is too old")
            else:
                return (2, "HBF status answers with: {}".format(r.status_code))
        except Exception as e:
            if self.check_is_hbf_running():
                return (2, "Could not get status from hbf: {}".format(e))
            else:
                return (2, "{} porto container is not running".format(self.hbf_porto_container_name))

        return (0, 'OK')


@as_check(name=CHECK_NAME)
def juggler_check():
    j = JugglerHBFCheck()
    status, desc = j.check_hbf_status()
    status = STATUS_MAP[status]
    return Event(status, desc)
