"""
Checking duplicate LL address on MTN interfaces
"""
from juggler.bundles import as_check, Status
from infra.rtc.juggler.bundle.util import WalleCompatEvent
from subprocess import run, PIPE
from netifaces import interfaces, ifaddresses, AF_INET6


CHECK_NAME = 'll_duplicate_addr'

IFACES = ('vlan688', 'vlan788')
cmd_ndisc6 = ('/usr/bin/ndisc6', '-n', '-r', '1')


@as_check(name=CHECK_NAME)
def juggler_check():
    ifaces = interfaces()
    for iface in filter(lambda i: i in IFACES, ifaces):
        for addrs in ifaddresses(iface).get(AF_INET6):
            if addrs.get('addr').startswith('fe80::a:'):
                ll_addr = addrs['addr'].split('%')[0]
                try:
                    resp = run(cmd_ndisc6+(ll_addr, iface), stdout=PIPE, stderr=PIPE)
                    if resp.stderr:
                        raise Exception(resp.stderr.decode('utf-8').split('\n')[0])
                    if 'address' in resp.stdout.decode('utf-8'):
                        return WalleCompatEvent(Status.CRIT, "Found duplicate address {} on {}".format(ll_addr, iface))
                except Exception as e:
                    return WalleCompatEvent(Status.WARN, str(e))
    return WalleCompatEvent(Status.OK, 'Ok')
