"""
Checks memory bandwith
"""

import subprocess

from juggler.bundles import as_check, Status
from infra.rtc.juggler.bundle.util import WalleCompatEvent as Event


CHECK_NAME = 'numa_memorybw'


def get_numa_bandwith():
    output = subprocess.check_output(["/usr/bin/numactl", "-N", "0", "/usr/bin/perf", "bench", "-f", "simple", "mem", "memcpy", "--nr_loops", "3", "-s", "256MB", "-f", "x86-64-movsb"])
    """
    command output:
    aculage@aculage-dev:~$ /usr/bin/numactl -N 0 /usr/bin/perf bench -f simple mem memcpy --nr_loops 3 -s 256MB -f x86-64-movsb | cat -e
    # function 'x86-64-movsb' (movsb-based memcpy() in arch/x86/lib/memcpy_64.S)$
    4802903118.164617$
    """
    numabw = float(output.split(b'\n')[1]) / 1024**3
    if numabw <= 1.5:
        return Status.CRIT, f'{numabw:.2f} GB/s'
    else:
        return Status.OK, f'{numabw:.2f} GB/s'


def perform_check():
    try:
        with open('/proc/cpuinfo', 'r') as f:
            for _, line in enumerate(f):
                if line[:10] == 'model name':
                    if 'AMD EPYC' in line:
                        return get_numa_bandwith()
                    else:
                        return Status.OK, ""
            return Status.OK, ""
    except Exception as e:
        return Status.WARN, str(e)


@as_check(name=CHECK_NAME)
def juggler_check():
    status, desc = perform_check()
    return Event(status, desc)
