"""
Checks for tcp-sampler
"""

import time
import os

from juggler.bundles import as_check, Status, Event

CHECK_NAME = 'tcp_sampler_dump'
DUMP_PATH = '/tmp/tcp-sampler.message.dump'


STATUS_MAP = {
    0: Status.OK,
    1: Status.WARN,
    2: Status.CRIT,
}


class JugglerTCPSamplerCheck(object):
    max_timedelta = 24 * 60 * 60

    def check_dump_timestamp(self):
        try:
            stat = os.stat(DUMP_PATH)
            time_delta = time.time() - stat.st_mtime

            if time_delta > self.max_timedelta:
                return (2, "dump timestamp is too old")
            if stat.st_size <= 0:
                return (2, "dump size is too small")
        except Exception as e:
            if get_uptime() > self.max_timedelta:
                return (2, "Could not get dump timestamp: {}".format(e))
        return (0, 'OK')


def get_uptime():
    with open('/proc/uptime', 'r') as f:
        return float(f.readline().split()[0])


@as_check(name=CHECK_NAME)
def juggler_check():
    j = JugglerTCPSamplerCheck()
    status, desc = j.check_dump_timestamp()
    status = STATUS_MAP[status]
    return Event(status, desc)
