#!/usr/bin/env python
# Provides: abnormal_ip_conf
# -*- coding: utf-8 -*-

import sys
import subprocess

name = 'abnormal_ip_conf'


def die(name, status, msg):
    print("PASSIVE-CHECK:%s;%s;%s" % (name, status, msg))
    sys.exit(0)


def get_devices():
    res = subprocess.check_output(['ip', 'link'])
    devices = []
    for l in res.split('\n'):
        l = l.strip()
        if not l:
            continue
        eth = l.split()[1]
        if eth.startswith('eth') and '@' not in eth:
            devices.append(eth[:-1])
    return devices


def check_ips(interface):
    cmd = ['ip', 'addr', 'show', 'dev', interface]
    res = subprocess.check_output(cmd)
    all_ips = []
    deprecated_ips = []
    for line in res.split('\n'):
        line = line.strip()
        if line[-len('scope global dynamic'):] == 'scope global dynamic':
            ip = line.split()[1]
            all_ips.append(ip)
        if line[-len('scope global deprecated dynamic'):] == 'scope global deprecated dynamic':
            ip = line.split()[1]
            deprecated_ips.append(ip)
    return {'all_ips': all_ips, 'deprecated_ips': deprecated_ips}


def main():
    devices = get_devices()
    msg = ''
    for dev in devices:
        res = check_ips(dev)
        if len(res['all_ips']) > 1:
            msg += '{} has {} IP addresses: {};'.format(dev, len(res), res)
        if len(res['deprecated_ips']) > 0:
            msg += '{} has deprecated IP address;'.format(dev)
    if msg != '':
        die(name, 2, msg)
    else:
        die(name, 0, 'Ok')


if __name__ == '__main__':
    main()
