#!/bin/sh
#
# Provides: check_atop
#

me=${0##*/}
me=${me%.*}

FILES="/var/log/atop.log*"

die () {
    echo "PASSIVE-CHECK:$me;$1;$2"
    exit 0
}

if [ ! -e /var/log/atop/atop.log ]; then
    die 2 "Can't find /var/log/atop/atop.log"
fi

for f in $FILES; do
    if [ -e $f ];then
      die 1 "found: $f"
    fi
done

die 0 "Ok"
